############### ###############
## cbo_regression3.R
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 08/06/2022
############### ###############

# Function to export regression results in appropriate format for publication tables and forest plots (tibble)

cbo_regression3 <- function(estimation, outcome.var = ""){
  estimation %>% 
    ## Adjustments to prepare forest plot ##
    tidy(conf.int = T) %>% #Confidence interval
    mutate(observations = nobs(estimation)) %>% #Number of observations 
    mutate(outcome = outcome.var) %>%
    select(outcome, everything()) %>%
    slice(2)
}
